<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use stdClass;
use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;
use DateInterval;
use DatePeriod;
use DateTime;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    protected $db;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var array
     */
    protected $helpers = ["ApiResponse","table_sql"];
   
    /**
     * Constructor.
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        // Preload any models, libraries, etc, here.

        // E.g.: $this->session = \Config\Services::session();
        $this->db = \Config\Database::connect();

        $response
            ->setHeader('Access-Control-Allow-Origin', '*')
            ->setHeader('Access-Control-Allow-Headers', 'Token, Origin, X-Requested-With, Content-Type, Accept')
            ->setHeader('Access-Control-Allow-Methods', 'GET, POST, PUT');
    }
    public function verify_login() {

     
        $ret = new stdClass();
        $ret->NotLogged = ($this->get_logged_user() == null || ($this->get_logged_user())->MesajEroare != null);
        $ret->Error       = false;
        $ret->MesajEroare = $this->get_logged_user() !== null ? ($this->get_logged_user())->MesajEroare : "";
        
        return $ret;
    }
    public function get_logged_user() {
        $token          = $this->request->getHeaderLine("token");
        $client         = $this->db->query("SELECT * FROM auth_token WHERE Token='$token' ORDER BY Id DESC")->getRow();
        
        $currentDate = time();
         
        $pastDate = $currentDate - (20 * 60);
        
        $currentDatePast20minutes = date("Y-m-d H:i:s", $pastDate);

        if($client != null){
            $client->MesajEroare = null;
            $user       = $this->db->query('SELECT * FROM utilizatori WHERE Id=?',[$client->IdUtilizator])->getRow();
            $differenceInMinutes = ($currentDate - strtotime($user->LastSeen)) / 60;
            
            if(empty($user) || $client->DataExpirare < date('Y-m-d H:i:s') || $user->LastSeen < $currentDatePast20minutes){
                $client = new stdClass();
                $client->MesajEroare = "Sesiunea a expirat!";
            }elseif($differenceInMinutes > 5){
                $this->db->table('utilizatori')
                ->where('Id', $client->IdUtilizator)
                ->update(['LastSeen' => date('Y-m-d H:i:s')]);
            }         
        }
        return $client;
    }

    public function get_user_from_token(){
        $token          = $this->request->getHeaderLine("token");
        
        $utilizator = $this->db->query("SELECT IdUtilizator FROM auth_token WHERE Token='$token'")->getResult();
           
        return $utilizator[0]->IdUtilizator;
    }

    public function getUserDetails()
    {
    $token          = $this->request->getHeaderLine("token");
        
    $IdUtiliator = ($this->db->query("SELECT IdUtilizator FROM auth_token WHERE Token='$token'")->getRow())->IdUtilizator;

    if($IdUtiliator){
        return $this->db->query("SELECT * FROM utilizatori WHERE Id = " . $IdUtiliator)->getRow();
        }
    }

    public function get_date_between($data1, $data2) {
        $begin      = new DateTime( $data1 );
        $end        = new DateTime( $data2 );
        $end        = $end->modify( '+1 day' ); 

        $interval   = new DateInterval('P1D');
        $daterange  = new DatePeriod($begin, $interval ,$end);

        $ret        = [];
        foreach($daterange as $date){
            $ret[] = $date->format("Y-m-d");
        }
        return $ret;
    }

}
