<?php

namespace App\Controllers;

use ApiResponse;
use App\Controllers\BaseController;
use CodeIgniter\Database\BaseConnection;
use PaginationInfo;
use stdClass;
use TableSql;

class Login extends BaseController
{
    public function login(){
        $ret = new ApiResponse();
        
        $email      = $this->request->getPost("email"   );
        $parola     = $this->request->getPost("parola"  );
        
        $user       = $this->db->query('SELECT * FROM utilizatori WHERE Email=? AND Parola=? AND Sters = 0', [ $email, md5(strval($parola)) ] )->getRow();
        if ( $user == null ) {
            $ret->setError("Date incorecte!");
        } else {

            $datetime = date('Y-m-d H:i:s', strtotime('+24 hours'));
            $token = bin2hex(random_bytes(16));

            $currentDate = time();
            $futureDate = strtotime("+5 minute", $currentDate);
            $formatDate = date("Y-m-d H:i:s", $futureDate);
            
            $data = [
                'IdUtilizator' => $user->Id,
                'DataExpirare' => $datetime,
                'Token' => $token,
            ];

            $this->db->table('auth_token')->insert($data);

            $ret->expiry             = date('Y-m-d H:i:s');
            $ret->Token             = $token;
            $ret->Nume              = $user->Nume;
            $ret->Email             = $user->Email;
            if($formatDate>$user->LastSeen){
                $this->db->table('utilizatori')->where('Id', $user->Id)->update(['LastSeen' => date('Y-m-d H:i:s')]);
            }
        }
        
        // echo json_encode($ret);
        return $this->response->setJSON($ret);
    }
}
